
export WANDB_PROJECT=Video-GRPO
export WANDB_NAME=SceneFun3D_2

export PYTHONPATH=".:$PYTHONPATH"
OUTDIR=outputs/scenefun3d_2

export DEBUG_MODE="true"
export LOG_PATH="logs/scenefun3d_2.log"

CUDA_VISIBLE_DEVICES=1,2 torchrun --nproc_per_node="2" \
    --nnodes="1" \
    --node_rank="0" \
    --master_addr="127.0.0.1" \
    --master_port="12361" \
    src/open_r1/grpo_video.py \
    --deepspeed scripts/zero3_offload.json \
    --output_dir $OUTDIR \
    --model_name_or_path /data2/huggingface/Qwen/Qwen2.5-VL-7B-Instruct \
    --preprocessed_data_path /data2/datasets/scenefun3d_preprocessed_data_maxpix_3584 \
    --train_data_path ./dataset/scenefun3d/train.json \
    --eval_data_path ./dataset/scenefun3d/val.json \
    --video_folder /data2/datasets/scenefun3d_video \
    --dataset_name scanrefer \
    --max_prompt_length 8192 \
    --max_completion_length 1024 \
    --num_generations 8 \
    --per_device_train_batch_size 1 \
    --gradient_accumulation_steps 2 \
    --logging_steps 1 \
    --bf16 \
    --torch_dtype bfloat16 \
    --data_seed 42 \
    --gradient_checkpointing true \
    --attn_implementation flash_attention_2 \
    --num_train_epochs 4 \
    --run_name $WANDB_NAME \
    --report_to wandb \
    --save_steps 500 \
    # --use_vllm True \
    # --vllm_gpu_memory_utilization 0.8 \
    # --save_only_model true # /data2/huggingface/Qwen/Qwen2.5-VL-7B-Instruct \

